;***********************************************************************************************************************
;*   SUPER_JOYSTICK_PORT_2.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;*
;* 150214-03
;***********************************************************************************************************************

;***********************************************************************************************************************
;*    "SUPER JOYSTICK PORT 2"
;*
;*  = ATMEGA48PA-AU   11,0592 
;*     = ConTEXT
;*  = ASM32
;*    = AVRDUDE  
;*  = "FT232 AVR PROG" (ZXkit-029)
;***********************************************************************************************************************

.include "m48def.inc"
.include "MACRO.asm"
.include "EQU.asm"
.include "DEF.asm"
.include "INTERRUPTS.asm"               ;  -     
.include "DATA.asm"                     ;    FLASH    

;***********************************************************************************************************************
;* 150214-03                              
;***********************************************************************************************************************
Main:
        ldi     temp,low(RAMEND)        ;     
        out     SPL,temp
        ldi     temp,high(RAMEND)
        out     SPH,temp

;--------------------------------------   - --------------------------------------------------

        INIT_PORTS                      ;   -
        CLR_REG_SHIFT                   ;       
        CLR_REG_LATCH                   ;       
        SET_SEGA_SYN                    ;     SEGA 

;--------------------------------------     ----------------------------------------

        ldi     yh,1                    ;     
        rcall   ClearOutBuf             ;    -    
        rcall   OutBufToRegs            ;      

;--------------------------------------    INT1 ----------------------------------------------

;         ldi     temp,(1<<ISC11)         ;   INT1     PS/2 
;         sts     EICRA,temp
;         ldi     temp,(1<<INT1)
;         out     EIMSK,temp
;--------------------------------------     0   50  ---------------------------

        ldi     temp,(1<<WGM01)         ;  CTC (  )
        out     TCCR0A,temp
        ldi     temp,(1<<CS01)          ;   clk/8
        out     TCCR0B,temp
        ldi     temp,68                 ;    0  68
        out     OCR0A,temp              ;    T=(8*69)/11.0592=49.9 
        ldi     temp,(1<<OCIE0A)        ;      =68
        sts     TIMSK0,temp

        ldi     cnt_tim0,0              ;     0
        ldi     sega_state,PROCESS      ;       SEGA 
        rcall   Delay1S                 ;  1 
        sei                             ;  

;--------------------------------------   -    -------------------------
;                                            

MainCycle:
        cpi     sega_state,READY        ;    SEGA  ?
        breq    SegaToOut

        rjmp    MainCycle


SegaToOut:
        rcall   ClearOutBuf             ;    -    
        rcall   WorkSegaData            ;    SEGA 
        ldi     sega_state,PROCESS      ;    SEGA  ,    
        rcall   OutBufToRegs            ;      

        rjmp    MainCycle

;***********************************************************************************************************************
;* 150214-01                               -    
;***********************************************************************************************************************
ClearOutBuf:
        ldi     yl,0                    ;     
        ldi     cnt,48                  ;    -   
        ldi     temp,1

ClearOutBuf_10:
        st      y+,temp                 ;     1,      
        dec     cnt                     ;         1 -  
        brne    ClearOutBuf_10

        ret

;***********************************************************************************************************************
;* 150211-02                               SEGA 
;***********************************************************************************************************************
WorkSegaData:
        ldi     yl,KEY_1                ;        "1"
        ldi     temp,0                  ;  0 (  )
        st      y,temp                  ;     
        ret

;***********************************************************************************************************************
;* 150213-01                                 
;***********************************************************************************************************************
OutBufToRegs:
        ldi     yl,0                    ;     
;--------------------------------------  DD10 -------------------------------------------------------------------
        SHIFT_KEY_TO_REGS               ;         
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
;--------------------------------------  DD9 --------------------------------------------------------------------
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS                      ;   
        SHIFT_REGS
        SHIFT_REGS
;--------------------------------------  DD8 --------------------------------------------------------------------
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
;--------------------------------------  DD7 --------------------------------------------------------------------
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_REGS
;--------------------------------------  DD6 --------------------------------------------------------------------
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
;--------------------------------------  DD5 --------------------------------------------------------------------
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_REGS
;--------------------------------------  DD4 --------------------------------------------------------------------
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
;--------------------------------------  DD3 --------------------------------------------------------------------
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_REGS
;--------------------------------------  DD2 --------------------------------------------------------------------
        SHIFT_REGS
        SHIFT_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_KEY_TO_REGS
        SHIFT_REGS
;-----------------------------------------------------------------------------------------------------------------------
        LATCH_REGS                      ;         
        ret

;***********************************************************************************************************************
;* 150214-01                              1 
;***********************************************************************************************************************
Delay1S:
        ldi     temp,$00                ;    $21C000
        ldi     mask,$C0
        ldi     cnt,$21

Delay1S_10:
        subi    temp,1
        sbci    mask,0
        sbci    cnt,0
        brcc    Delay1S_10
        ret

;***********************************************************************************************************************
